<?php

$this->pageTitle = Yii::app()->name . ' - Panel nauczyciela';

$this->breadcrumbs = array(
	'Dokumenty uczniów'
);


Yii::app()->clientScript->registerScript('form', '

', CClientScript::POS_READY);

?>
<h1>Dokumenty uczniów</h1>

<br />

<h3>Wszystkie dokumenty do zaakceptowania</h3>

<?php
	$this->widget('zii.widgets.grid.CGridView', array(
		'id'=>'documents-to-accept',
		'dataProvider'=>$documentsToAccept,
		'htmlOptions' => array('class'=>'tDefault'),
		'columns'=>array(
			array(
				'name'=>'uczen',
				'header'=>'Uczeń',
				'value'=>'$data["nazwisko"]." ".$data["imie"]',
			),
			array(
				'name'=>'nazwaFirmy',
				'header'=>'Nazwa firmy',
			),
			array(
				'name'=>'nazwaFormulrza',
				'header'=>'Nazwa formularza',
				'value'=>'\'<a href="\'.Yii::app()->createUrl("teacher/main/form",array("userFormId"=>$data["id"])).\'">\'.$data["nazwaFormularza"].\'</a>\'',
				'type'=>'raw'
			),
			array(
				'name'=>'dataModyfikacji',
				'value'=>'date("Y-m-d H:i", strtotime($data["dataModyfikacji"]))',
			),
			array(
				'header'=>'Status',
				'value'=>'FormularzUzytkownika::$statusName[$data["status"]]'
			),
			array(
				'header'=>'Akcje',
				'value'=>'($data["status"]==FormularzUzytkownika::STATUS_FILLED || $data["status"]==FormularzUzytkownika::STATUS_REFUSED ?\'<a class="buttonS bGreen" href="\'.Yii::app()->createUrl("teacher/main/formStatusChange",array("userFormId"=>$data["id"],"status"=>FormularzUzytkownika::STATUS_ACCEPTED)).\'">Zaakceptuj</a>\':""). ($data["status"]==FormularzUzytkownika::STATUS_REFUSED?\' | \':""). ($data["status"]==FormularzUzytkownika::STATUS_FILLED?\'<a style="margin-left: 10px;" class="buttonS bRed" href="\'.Yii::app()->createUrl("teacher/main/formStatusChange",array("userFormId"=>$data["id"],"status"=>FormularzUzytkownika::STATUS_REFUSED)).\'">Odrzuć</a>\':"")',
				'type'=>'raw',
				'htmlOptions'=>array('style'=>'width: 170px;')
			)
		),
	));
?>

<?php if(Yii::app()->user->hasFlash('formStatusChanged')): ?>
	<div class="flash-success">
		<?php echo Yii::app()->user->getFlash('formStatusChanged'); ?>
	</div>
<?php endif; ?>

<?php
foreach($classes as $index => $class)
{
	echo '<h3>'.$class->nazwa.'</h3>';

	$this->widget('zii.widgets.grid.CGridView', array(
		'id'=>'parametry-gry-grid-' . $index,
		'dataProvider'=>$class->getDocuments(),
		'htmlOptions' => array('class' => 'tDefault'),
		'columns'=>array(
			array(
				'name'=>'uczen',
				'header'=>'Uczeń',
				'value'=>'$data["nazwisko"]." ".$data["imie"]',
			),
			array(
				'name'=>'nazwaFirmy',
				'header'=>'Nazwa firmy',
			),
			array(
				'name'=>'nazwaFormulrza',
				'header'=>'Nazwa formularza',
				'value'=>'\'<a href="\'.Yii::app()->createUrl("teacher/main/form",array("userFormId"=>$data["id"])).\'">\'.$data["nazwaFormularza"].\'</a>\'',
				'type'=>'raw'
			),
			array(
				'name'=>'dataModyfikacji',
				'value'=>'date("Y-m-d H:i", strtotime($data["dataModyfikacji"]))',
			),
			array(
				'header'=>'Status',
				'value'=>'FormularzUzytkownika::$statusName[$data["status"]]'
			),
			array(
				'header'=>'Akcje',
				'value'=>'($data["status"]==FormularzUzytkownika::STATUS_FILLED || $data["status"]==FormularzUzytkownika::STATUS_REFUSED ?\'<a class="buttonS bGreen" href="\'.Yii::app()->createUrl("teacher/main/formStatusChange",array("userFormId"=>$data["id"],"status"=>FormularzUzytkownika::STATUS_ACCEPTED)).\'">Zaakceptuj</a>\':""). ($data["status"]==FormularzUzytkownika::STATUS_REFUSED?\' | \':""). ($data["status"]==FormularzUzytkownika::STATUS_FILLED?\'<a style="margin-left: 10px;" class="buttonS bRed" href="\'.Yii::app()->createUrl("teacher/main/formStatusChange",array("userFormId"=>$data["id"],"status"=>FormularzUzytkownika::STATUS_REFUSED)).\'">Odrzuć</a>\':"")',
				'type'=>'raw',
				'htmlOptions'=>array('style'=>'width: 170px;')
			)
		),
	));
}
?>
